// SwatchRandom.jsx
// www.illustratorscripts.com
// A. Gontis
// MIT License
//
// Applies selected swatches to selected objects randomly.
// Single text frame: colors each character. Multiple objects: colors each item.
// Useful for quickly colorizing illustrations, icons, or text with a palette.

var RANDOM = true;

(function() {
    if (app.documents.length === 0) {
        alert("No document open.");
        return;
    }

    var doc = app.activeDocument;
    var sel = doc.selection;

    if (!sel || sel.length === 0) {
        alert("No objects selected.");
        return;
    }

    var swatches = doc.swatches.getSelected();

    if (swatches.length === 0) {
        alert("No swatches selected.");
        return;
    }

    var idx = {val: 0};

    function nextColor() {
        if (RANDOM) {
            return swatches[Math.floor(Math.random() * swatches.length)].color;
        }
        if (idx.val >= swatches.length) idx.val = 0;
        return swatches[idx.val++].color;
    }

    function processItem(item) {
        var type = item.typename;

        if (type === "GroupItem") {
            for (var j = 0; j < item.pageItems.length; j++) {
                processItem(item.pageItems[j]);
            }
        } else if (type === "CompoundPathItem") {
            var color = nextColor();
            for (var k = 0; k < item.pathItems.length; k++) {
                item.pathItems[k].fillColor = color;
            }
        } else if (type === "PathItem") {
            item.fillColor = nextColor();
        } else if (type === "TextFrame") {
            item.textRange.characterAttributes.fillColor = nextColor();
        }
    }

    // Single TextFrame: cycle colors per character
    if (sel.length === 1 && sel[0].typename === "TextFrame") {
        var chars = sel[0].textRange.characters;
        for (var c = 0; c < chars.length; c++) {
            chars[c].characterAttributes.fillColor = nextColor();
        }
        return;
    }

    // Multiple items: cycle colors per item (recursive)
    for (var i = 0; i < sel.length; i++) {
        processItem(sel[i]);
    }
})();
