
#target illustrator

function CoreSimpleSankeyFree() {
  if (app.documents.length === 0) {
    alert("Please open a document before running the script.");
    return;
  }

  var doc = app.activeDocument;

  // Dialog setup
  var dialog = new Window("dialog", "Core Simple Sankey Free");
  dialog.alignChildren = "fill";

  dialog.add("statictext", undefined, "Enter Chart Title:");
  var chartTitleField = dialog.add("edittext", undefined, "Campaign Results");
  chartTitleField.characters = 30;

  dialog.add("statictext", undefined, "Enter Source Title:");
  var sourceTitleField = dialog.add("edittext", undefined, "Marketing Channel");
  sourceTitleField.characters = 20;

  dialog.add("statictext", undefined, "Enter Source Value (optional):");
  var sourceValueField = dialog.add("edittext", undefined, "");
  sourceValueField.characters = 20;

  dialog.add("statictext", undefined, "Enter flow data (Label, Value):");

  var flowInputs = [];
  var defaults = [["", ""], ["", ""], ["", ""], ["", ""]];

  for (var i = 0; i < 4; i++) {
    var group = dialog.add("group");
    group.add("statictext", undefined, "Label:");
    var labelField = group.add("edittext", undefined, defaults[i][0]);
    labelField.characters = 12;
    group.add("statictext", undefined, "Value:");
    var valField = group.add("edittext", undefined, defaults[i][1]);
    valField.characters = 6;
    flowInputs.push({ label: labelField, value: valField });
  }

  dialog.add("statictext", undefined, "Spacing between outputs (pts):");
  var spacingField = dialog.add("edittext", undefined, "15");
  spacingField.characters = 4;

  dialog.add("statictext", undefined, "Source Curve Handle (left, pts):");
  var leftHandleField = dialog.add("edittext", undefined, "25");
  leftHandleField.characters = 4;

  dialog.add("statictext", undefined, "Termination Curve Handle (right, pts):");
  var rightHandleField = dialog.add("edittext", undefined, "80");
  rightHandleField.characters = 4;

  dialog.add("statictext", undefined, "Distance from source to target (pts):");
  var distanceField = dialog.add("edittext", undefined, "290");
  distanceField.characters = 4;

  dialog.add("statictext", undefined, "Right side alignment:");
  var alignmentDropdown = dialog.add("dropdownlist", undefined, ["Top", "Center", "Bottom"]);
  alignmentDropdown.selection = 1;

  var buttons = dialog.add("group");
  buttons.alignment = "center";
  buttons.add("button", undefined, "Generate", { name: "ok" });
  buttons.add("button", undefined, "Cancel", { name: "cancel" });

  if (dialog.show() !== 1) return;

  var spacing = parseFloat(spacingField.text);
  if (isNaN(spacing)) spacing = 10;
  var leftHandle = parseFloat(leftHandleField.text);
  if (isNaN(leftHandle)) leftHandle = 40;
  var rightHandle = parseFloat(rightHandleField.text);
  if (isNaN(rightHandle)) rightHandle = 60;
  var distance = parseFloat(distanceField.text);
  if (isNaN(distance)) distance = 240;

  var sourceTitle = sourceTitleField.text;
  var sourceValue = sourceValueField.text;
  var alignMode = alignmentDropdown.selection.text.toLowerCase();

  var flows = [];
  for (var i = 0; i < flowInputs.length; i++) {
    var label = String(flowInputs[i].label.text).replace(/^\s+|\s+$/g, "");
    var val = parseFloat(flowInputs[i].value.text);
    if (label && !isNaN(val)) flows.push([label, val]);
  }

  if (flows.length === 0) {
    alert("No valid flows entered.");
    return;
  }

  var totalValue = 0;
  for (var i = 0; i < flows.length; i++) {
    totalValue += flows[i][1];
  }

  var outputHeights = [];
  for (var i = 0; i < flows.length; i++) {
    outputHeights.push((flows[i][1] / totalValue) * 216);
  }

  var totalOutputHeight = 0;
  for (var i = 0; i < outputHeights.length; i++) {
    totalOutputHeight += outputHeights[i];
  }

  var layer = doc.layers.add();
  layer.name = "Core Simple Sankey Free";

  var artboard = doc.artboards[doc.artboards.getActiveArtboardIndex()];
  var abBounds = artboard.artboardRect;
  var artboardWidth = abBounds[2] - abBounds[0];
  var artboardHeight = abBounds[1] - abBounds[3];
  var xSource = abBounds[0] + (artboardWidth - (144 + distance)) / 2;
  var yTop = abBounds[1] - (artboardHeight - 216) / 2;
  var boxWidth = 144;
  var boxHeight = 216;
  var xTarget = xSource + distance;

  var sourceLayer = doc.layers.add();
  sourceLayer.name = "Source Label";

  if (chartTitleField && chartTitleField.text) {
  var titleText = doc.textFrames.add();
  titleText.contents = chartTitleField.text;
  titleText.position = [xSource, yTop + 40];
  titleText.textRange.characterAttributes.size = 14;
  try {
    titleText.textRange.characterAttributes.textFont = app.textFonts.getByName("MyriadPro-Bold");
  } catch (e) {}
}

var sourceBox = sourceLayer.pathItems.rectangle(yTop, xSource, boxWidth, boxHeight);
  sourceBox.filled = true;
  var black = new GrayColor();
  black.gray = 100;
  sourceBox.fillColor = black;
  sourceBox.stroked = false;

  var sourceText = sourceLayer.textFrames.add();
  sourceText.contents = sourceValue ? (sourceTitle + "\r" + sourceValue) : sourceTitle;
  sourceText.position = [xSource + 10, yTop - 20];
  sourceText.textRange.characterAttributes.size = 12;
  var whiteText = new GrayColor();
  whiteText.gray = 0;
  sourceText.textRange.characterAttributes.fillColor = whiteText;

  var currentY = yTop;
  var rightY = alignMode === "top" ? yTop :
               alignMode === "center" ? yTop - ((boxHeight - totalOutputHeight - (spacing * (flows.length - 1))) / 2) :
               yTop;  var usedColors = [];

  function isColorUsed(c, colors) {
    for (var j = 0; j < colors.length; j++) {
      if (Math.abs(colors[j].red - c.red) < 10 &&
          Math.abs(colors[j].green - c.green) < 10 &&
          Math.abs(colors[j].blue - c.blue) < 10) {
        return true;
      }
    }
    return false;
  }

  for (var i = 0; i < flows.length; i++) {
    var label = flows[i][0];
    var value = flows[i][1];
    var sliceHeight = outputHeights[i];
    var midYLeft = currentY - sliceHeight / 2;
    var midYRight = rightY - sliceHeight / 2;

    var color = new GrayColor();
    color.gray = 60;
    usedColors.push(color);

    var path = layer.pathItems.add();
    path.stroked = true;
    path.strokeWidth = sliceHeight;
    path.filled = false;
    path.strokeColor = color;

    var pt0 = path.pathPoints.add();
    var pt1 = path.pathPoints.add();
    pt0.anchor = [xSource + boxWidth, midYLeft];
    pt0.leftDirection = [xSource + boxWidth, midYLeft];
    pt0.rightDirection = [xSource + boxWidth + leftHandle, midYLeft];
    pt1.anchor = [xTarget, midYRight];
    pt1.leftDirection = [xTarget - rightHandle, midYRight];
    pt1.rightDirection = [xTarget, midYRight];

    var labelText = doc.textFrames.add();
    labelText.contents = label + "\r" + value;
    labelText.position = [xTarget + 10, midYRight + 10];
    labelText.textRange.characterAttributes.size = 10;
    labelText.textRange.lines[1].characterAttributes.size = 8;

    currentY -= sliceHeight;
    rightY -= sliceHeight + spacing;
  }

  alert("Sankey chart created!");
}

CoreSimpleSankeyFree();
