// author: aivaras gontis
// www.illustratorscripts.com



if (app.documents.length === 0) {
    alert("Please open a document first");
} else if (app.activeDocument.selection.length === 0) {
    alert("Please select an object first");
} else {
    var doc = app.activeDocument;
    var sel = doc.selection[0];

    // Create dialog
    var dlg = new Window("dialog", "Inner Shadow Filter");
    dlg.alignChildren = "fill";

    // X offset
    var xGroup = dlg.add("group");
    xGroup.add("statictext", undefined, "X Offset:");
    var xSlider = xGroup.add("slider", undefined, 2, -10, 10);
    xSlider.size = [200, 20];
    var xInput = xGroup.add("edittext", undefined, "2");
    xInput.characters = 5;

    // Y offset
    var yGroup = dlg.add("group");
    yGroup.add("statictext", undefined, "Y Offset:");
    var ySlider = yGroup.add("slider", undefined, 3, -10, 10);
    ySlider.size = [200, 20];
    var yInput = yGroup.add("edittext", undefined, "3");
    yInput.characters = 5;

    // Blur
    var blurGroup = dlg.add("group");
    blurGroup.add("statictext", undefined, "Blur:");
    var blurSlider = blurGroup.add("slider", undefined, 1, 0, 20);
    blurSlider.size = [200, 20];
    var blurInput = blurGroup.add("edittext", undefined, "1");
    blurInput.characters = 5;

    // Opacity
    var opacityGroup = dlg.add("group");
    opacityGroup.add("statictext", undefined, "Opacity:");
    var opacitySlider = opacityGroup.add("slider", undefined, 0.4, 0, 1);
    opacitySlider.size = [200, 20];
    var opacityInput = opacityGroup.add("edittext", undefined, "0.40");
    opacityInput.characters = 5;

    // Sync sliders with inputs
    xSlider.onChanging = function() { xInput.text = Math.round(this.value * 10) / 10; };
    xInput.onChange = function() { xSlider.value = parseFloat(this.text) || 0; };

    ySlider.onChanging = function() { yInput.text = Math.round(this.value * 10) / 10; };
    yInput.onChange = function() { ySlider.value = parseFloat(this.text) || 0; };

    blurSlider.onChanging = function() { blurInput.text = Math.round(this.value * 10) / 10; };
    blurInput.onChange = function() { blurSlider.value = parseFloat(this.text) || 0; };

    opacitySlider.onChanging = function() { opacityInput.text = Math.round(this.value * 100) / 100; };
    opacityInput.onChange = function() { opacitySlider.value = parseFloat(this.text) || 0; };

    // Buttons
    var btnGroup = dlg.add("group");
    var applyBtn = btnGroup.add("button", undefined, "Apply");
    var cancelBtn = btnGroup.add("button", undefined, "Cancel");

    applyBtn.onClick = function() {
        var xVal = parseFloat(xInput.text) || 2;
        var yVal = parseFloat(yInput.text) || 3;
        var blurVal = parseFloat(blurInput.text) || 1;
        var opacityVal = parseFloat(opacityInput.text) || 0.4;

        // Generate filter ID based on values - most visible properties first
        var filterId = "iShadow_blur" + blurVal + "_x" + xVal + "_y" + yVal + "_op" + opacityVal;

        // Generate SVG filter XML
        
        //author: Sean Barclay
        //https://gist.github.com/seanbarclay
        var svgFilterXML = '<?xml version="1.0" encoding="utf-8"?>\n' +
            '<svg xmlns="http://www.w3.org/2000/svg">\n' +
            '  <filter id="' + filterId + '">\n' +
            '    <feOffset dx="' + xVal + '" dy="' + yVal + '"/>\n' +
            '    <feGaussianBlur stdDeviation="' + blurVal + '" result="offset-blur"/>\n' +
            '    <feComposite operator="out" in="SourceGraphic" in2="offset-blur" result="inverse"/>\n' +
            '    <feFlood flood-color="black" flood-opacity="' + opacityVal + '" result="color"/>\n' +
            '    <feComposite operator="in" in="color" in2="inverse" result="shadow"/>\n' +
            '    <feComposite operator="over" in="shadow" in2="SourceGraphic"/>\n' +
            '  </filter>\n' +
            '</svg>';

        try {
            // Save to desktop
            var filterFile = new File(Folder.desktop + "/" + filterId + ".svg");
            filterFile.open("w");
            filterFile.write(svgFilterXML);
            filterFile.close();

            // Import SVG filter
            alert("Select latest svg file on the Desktop, then navigate to bottom of filters:\n" + filterFile.fsName + "\n\nThen click OK to apply.");
            app.executeMenuCommand("SVG Filter Import");

            // Apply the filter
            app.executeMenuCommand("Live SVG Filters");

            dlg.close();
        } catch (e) {
            alert("Error:\n" + e.toString());
        }
    };

    cancelBtn.onClick = function() {
        dlg.close();
    };

    dlg.show();
}
